/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.Blocks.BlockEntity.Ports;

import com.hoshino.cti.Blocks.BlockEntity.Ports.BasicPort;
import com.hoshino.cti.Blocks.BlockEntity.Ports.PortType;
import com.hoshino.cti.Blocks.BlockEntity.Ports.TransferType;
import com.hoshino.cti.util.ctiEnergyStore;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class EnergyInputPortBE
extends BasicPort {
    @NotNull
    public final ctiEnergyStore energyStorage;
    private LazyOptional<IEnergyStorage> energyOptional = LazyOptional.empty();

    public EnergyInputPortBE(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState, int energyStorage) {
        super(pType, pPos, pBlockState, PortType.ENERGY, TransferType.INPUT);
        this.energyStorage = new ctiEnergyStore(energyStorage, energyStorage){

            @Override
            public void onEnergyChange() {
                EnergyInputPortBE.this.m_6596_();
            }
        };
    }

    public void onLoad() {
        super.onLoad();
        this.energyOptional = LazyOptional.of(() -> this.energyStorage);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.energyOptional.invalidate();
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        this.energyStorage.writeToNbt(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.energyStorage.readFromNbt(pTag);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyOptional.cast();
        }
        return super.getCapability(cap);
    }

    @Override
    public void tick() {
        BlockEntity controller;
        super.tick();
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (this.controllerPos != null && (controller = this.f_58857_.m_7702_(this.f_58858_)) != null) {
            controller.getCapability(ForgeCapabilities.ENERGY).filter(IEnergyStorage::canExtract).ifPresent(energyHandler -> {
                int receive = Math.min(energyHandler.receiveEnergy(this.energyStorage.getEnergyStored(), true), this.energyStorage.extractEnergy(this.energyStorage.getEnergyStored(), true));
                if (receive > 0) {
                    energyHandler.receiveEnergy(receive, false);
                    this.energyStorage.extractEnergy(receive, false);
                }
            });
        }
    }
}

